%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for educational purposes 
%   associated with the book
%
%
%


%  Charged ring and an equivalent point charge


clear all;
close all;

Ql = input('Enter uniform charge per unit length of the ring in Coulombs per meter: ');
a = input('Enter radius of the ring in meters: ');
EPS0 = 8.854e-12;


Qtot = 2*pi*a*Ql; % total charge
dz = 0.01*a;
z = 20*dz:dz:10*a;
Ez =(z * Qtot)./(4*pi*EPS0*sqrt((z.^2 + a^2).^3));

% for z>>a
E = Qtot./(4*pi*EPS0*z.^2);

plot(z, Ez), hold on;
xlabel ('z (m)'), ylabel ('Electric field intensity (V/m)');
title ('Electric field comparison');
plot (z, E, 'r--');
legend ('Electric field due to charged ring','Electric field due to point charge',1);
hold off;